/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.fabricators_of_create.porting_lib.util.TagUtil;
import io.github.fabricators_of_create.porting_lib.util.TierSortingRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1832;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.DumpAllTagsCommand;
import slimeknights.mantle.command.DumpTagCommand;

public class HarvestTiersCommand {
    protected static final class_2960 HARVEST_TIERS = new class_2960("mantle", "item_tier_ordering.json");
    private static final String HARVEST_TIER_PATH = HARVEST_TIERS.method_12836() + "/" + HARVEST_TIERS.method_12832();
    private static final class_2561 SUCCESS_LOG = class_2561.method_43471((String)"command.mantle.harvest_tiers.success_log");
    private static final class_2561 EMPTY = class_2561.method_43471((String)"command.mantle.tag.empty");

    public static void register(LiteralArgumentBuilder<class_2168> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.method_9259(1))).then(class_2170.method_9247((String)"save").executes(source -> HarvestTiersCommand.run((CommandContext<class_2168>)source, true)))).then(class_2170.method_9247((String)"log").executes(source -> HarvestTiersCommand.run((CommandContext<class_2168>)source, false)))).then(class_2170.method_9247((String)"list").executes(HarvestTiersCommand::list));
    }

    private static Object getTagComponent(class_6862<class_2248> tag) {
        class_2960 id = tag.comp_327();
        return class_2561.method_43470((String)id.toString()).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11745, "/mantle dump_tag " + String.valueOf(class_7924.field_41254.method_29177()) + " " + String.valueOf(id) + " save")));
    }

    private static int list(CommandContext<class_2168> context) throws CommandSyntaxException {
        List sortedTiers = TierSortingRegistry.getSortedTiers();
        class_5250 output = class_2561.method_43471((String)"command.mantle.harvest_tiers.success_list");
        if (sortedTiers.isEmpty()) {
            output.method_27693("\n* ").method_10852(EMPTY);
        } else {
            for (class_1832 tier : sortedTiers) {
                output.method_27693("\n* ");
                class_6862 tag = TagUtil.getTagFromTier((class_1832)tier);
                class_2960 id = TierSortingRegistry.getName((class_1832)tier);
                if (tag != null) {
                    output.method_10852((class_2561)class_2561.method_43469((String)"command.mantle.harvest_tiers.tag", (Object[])new Object[]{id, HarvestTiersCommand.getTagComponent((class_6862<class_2248>)tag)}));
                    continue;
                }
                output.method_10852((class_2561)class_2561.method_43469((String)"command.mantle.harvest_tiers.no_tag", (Object[])new Object[]{id}));
            }
        }
        ((class_2168)context.getSource()).method_9226(() -> output, true);
        return sortedTiers.size();
    }

    private static int run(CommandContext<class_2168> context, boolean saveFile) throws CommandSyntaxException {
        List sortedTiers = TierSortingRegistry.getSortedTiers();
        JsonArray entries = new JsonArray();
        for (class_1832 location : sortedTiers) {
            entries.add(Objects.requireNonNull(TierSortingRegistry.getName((class_1832)location)).toString());
        }
        JsonObject json = new JsonObject();
        json.add("order", (JsonElement)entries);
        if (saveFile) {
            File output = new File(DumpAllTagsCommand.getOutputFile(context), HARVEST_TIER_PATH);
            Path path = output.toPath();
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(DumpTagCommand.GSON.toJson((JsonElement)json));
                }
            }
            catch (IOException ex) {
                Mantle.logger.error("Couldn't save harvests tiers to {}", (Object)path, (Object)ex);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.mantle.harvest_tiers.success_save", (Object[])new Object[]{DumpAllTagsCommand.getOutputComponent(output)}), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> SUCCESS_LOG, true);
            Mantle.logger.info("Dump of harvests tiers:\n{}", (Object)DumpTagCommand.GSON.toJson((JsonElement)json));
        }
        return sortedTiers.size();
    }
}

